


export class AppSettingsWidget {
	
	tpl = `
	<style type="text/css">
	.app-settings-widget input[name=adminUrl] { width: 300px; }
	</style>
	
	<div class="app-settings-widget">
		<div class="page-header">
			<div class="toolbox">
				<a href="{{appUrl('/masterdata/')}}" class="fa fa-chevron-circle-left"></a>
				<a href="javascript:void(0);" [onclick]="widget.save" class="fa fa-save"></a>
			</div>
			
			<h1>Instellingen</h1>
		</div>
		
		<span ez-if="settings == null">Loading...</span>
		
		<div ez-if="settings != null">
			<form id="frmSettings">
				<ez-text name="companyName" [value]="settings.companyName" label="Bedrijfsnaam"></ez-text>
				
				
				<span ez-if="hosted == false">
				<ez-text name="adminUrl" 
								[value]="settings.adminUrl"
								[placeholder]="adminUrlPlaceholder" 
								label="URL Administratie"></ez-text>
				</span>
				
			</form>
		</div>
	</div>
	`;
	
	container = null;
	ezTpl = null;
	settings = null;
	
	init(e) {
		this.container = e;
		this.render();
		
		this.loadSettings();
	}
	
	loadSettings() {
		postUrl( '/service/appsettings.do' ).then( async function(e) {
			let json = await e.json();
			this.settings = json.settings;
			this.render();
			
			// update title
			if (this.settings.companyName && $.trim(this.settings.companyName) != '') {
				$('.titlebar-company-name').text( this.settings.companyName + ' - ' );
			}
		}.bind(this) );
	}
	
	save() {
		let d = {};
		d.a = 'save';
		d.companyName = $('#frmSettings input[name=companyName]').val();
		d.adminUrl = $('#frmSettings input[name=adminUrl]').val();
		
		postUrl( '/service/appsettings.do', d )
		.then( async function(e) {
			reportUserMessage('Wijzigingen opgeslagen');
			
			replaceRoute( '/masterdata/appsettings/' );
		}.bind(this) );
	}
		
	
	
	render() {
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.setObject('widget', this);
		this.ezTpl.setVar('settings', this.settings);
		this.ezTpl.setVar('hosted', toolboxConfig.hosted);
		this.ezTpl.setVar('adminUrlPlaceholder', window.location.origin + appUrl('/'));
		
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.render();
		
	}
	
}

